---
description: "Learn more about: Aggregation functions"
title: "Aggregation functions (DAX) | Microsoft Docs"
---
# Aggregation functions

Aggregation functions calculate a (scalar) value such as count, sum, average, minimum, or maximum for all rows in a column or table as defined by the expression.

## In this category

|Function  |Description  |
|---------|---------|
|[APPROXIMATEDISTINCTCOUNT](approximate-distinctcount-function-dax.md)     |   Returns an *estimated* count of unique values in a column.     |
|[AVERAGE](average-function-dax.md)     |   Returns the average (arithmetic mean) of all the numbers in a column.       |
|[AVERAGEA](averagea-function-dax.md)     | Returns the average (arithmetic mean) of the values in a column.         |
|[AVERAGEX](averagex-function-dax.md)    | Calculates the average (arithmetic mean) of a set of expressions evaluated over a table.          |
|[COUNT](count-function-dax.md)      |  Counts the number of rows in the specified column that contain non-blank values.       |
|[COUNTA](counta-function-dax.md)     |  Counts the number of rows in the specified column that contain non-blank values.       |
|[COUNTAX](countax-function-dax.md)     |  Counts non-blank results when evaluating the result of an expression over a table.        |
|[COUNTBLANK](countblank-function-dax.md)     |  Counts the number of blank cells in a column.        |
|[COUNTROWS](countrows-function-dax.md)      |  Counts the number of rows in the specified table, or in a table defined by an expression.        |
|[COUNTX](countx-function-dax.md)       |  Counts the number of rows that contain a number or an expression that evaluates to a number, when evaluating an expression over a table.         |
|[DISTINCTCOUNT](distinctcount-function-dax.md)     |  Counts the number of distinct values in a column.         |
|[DISTINCTCOUNTNOBLANK](distinctcountnoblank-function-dax.md)    |   Counts the number of distinct values in a column.      |
|[MAX](max-function-dax.md)    |  Returns the largest numeric value in a column, or between two scalar expressions.        |
|[MAXA](maxa-function-dax.md)     |  Returns the largest value in a column.       |
|[MAXX](maxx-function-dax.md)       |  Evaluates an expression for each row of a table and returns the largest numeric value.        |
|[MIN](min-function-dax.md)     |  Returns the smallest numeric value in a column, or between two scalar expressions.       |
|[MINA](mina-function-dax.md)      | Returns the smallest value in a column, including any logical values and numbers represented as text.          |
|[MINX](minx-function-dax.md)      |  Returns the smallest numeric value that results from evaluating an expression for each row of a table.        |
|[PRODUCT](product-function-dax.md)      | Returns the product of the numbers in a column.         |
|[PRODUCTX](productx-function-dax.md)      | Returns the product of an expression evaluated for each row in a table.         |
|[SUM](sum-function-dax.md)     |  Adds all the numbers in a column.        |
|[SUMX](sumx-function-dax.md)     |   Returns the sum of an expression evaluated for each row in a table.       |
